#ifndef _FACTOR_H_
#define _FACTOR_H_

/*
 * FactorSet is a structure of enviroment factors.
 * Each default value(not assigned) is -1.
 * */
struct FactorSet {
	float B_tx;	/* Transmission bandwidth, Kbps */
	float B_rx;	/* Receiving bandwidth, Kbps */
	float t_comp;	/* Computations each time, us */
	float N_input;	/* Input data */
	float N_output;/* Output data */
	float U_cpu;	/* CPU capability */
	float U_cop;	/* Coprocessor capability */
	float U_cld;	/* Cloud capability */
	float U_mem;	/* Memory capability */

	float P_basic;	/* basic power when idle */
	float P_cpu;	/* mobile CPU running on full speed */
	float P_cop;	/* */
	float P_nic;

	/* Server information */
	char server_addr[50];
	int server_port;
};

#define CPU		0
#define GPU		1
#define CLOUD	2

extern void init_factor_set(struct FactorSet *);
extern void collect_factors(struct FactorSet *, FILE *);
extern void create_factor_table(struct FactorSet *);
extern void update_factor_table(struct FactorSet *);
extern float collect_bandwidth(const char *);
extern float collect_cpu_capability();
extern float collect_mem_capability();

#define FACTOR_TABLE	"Docs/factor-table.xml"

#endif /* _FACTOR_H_*/
